<?php
require_once 'vendor/autoload.php';

use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\IOFactory;
use PhpOffice\PhpWord\Shared\Html;

$phpWord = new PhpWord();
$section = $phpWord->addSection();

// Add your content here (same as your existing code)
$section->addTitle('Welcome to My Document', 1);
$section->addText('This is a simple Word document generated with PHP.');
$section->addText('Current PHP Version: 8.2.29', array('bold' => true));

// Add table
$table = $section->addTable();
$table->addRow();
$table->addCell(1500)->addText('Name');
$table->addCell(1500)->addText('Value');
$table->addRow();
$table->addCell(1500)->addText('PHP Version');
$table->addCell(1500)->addText('8.2.29');

// Add HTML content
$html = '<p>This is <strong>HTML content</strong> converted to Word format.</p>';
Html::addHtml($section, $html);

// Set headers for download
$filename = 'generated_document_' . date('Y-m-d') . '.docx';

header("Content-Description: File Transfer");
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Content-Type: application/vnd.openxmlformats-officedocument.wordprocessingml.document');
header('Content-Transfer-Encoding: binary');
header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
header('Expires: 0');
header('Pragma: public'); // :cite[2]:cite[7]

// Output the document directly to browser
$objWriter = IOFactory::createWriter($phpWord, 'Word2007');
$objWriter->save("php://output"); // :cite[2]
exit;
?>